/*
 * @(#)AMFactory.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.am;

import ch.hslu.cm.am.diagram.*;
import ch.hslu.cm.am.model.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.ChopDiamondConnector;
import org.jhotdraw.draw.connector.ChopEllipseConnector;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.connector.StickyRectangleConnector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.liner.SlantedLiner;
import org.jhotdraw.draw.locator.BezierLabelLocator;
import org.jhotdraw.xml.DefaultDOMFactory;

/**
 * Activity Modeling Factory.
 *
 *
 * @author Werner Randelshofer, Florian Padrun
 * @version 2006-01-18 Created.
 */
public class AMFactory extends DefaultDOMFactory {
    private final static Object[][] classTagArray = {
        // Old names
        { StickyRectangleConnector.class, "StickyChopConnector" },
        { ChopRectangleConnector.class, "ChopBoxConnector" },
        
        // New names
        { ActivityModel.class, "ActivityModel" },
        { AMInitialNode.class, "InitialNode" },
        { AMAction.class, "Action" },
        { AMDecisionNode.class, "DecisionNode" },
        { AMActivityFinalNode.class, "ActivityFinalNode" },
        { AMControlFlow.class, "ControlFlow" },
        
        { ActivityDiagram.class, "ActivityDiagram" },
        { AMInitialNodeFigure.class, "InitialNodeFigure" },
        { AMActionFigure.class, "ActionFigure" },
        { AMDecisionNodeFigure.class, "DecisionNodeFigure" },
        { AMActivityFinalNodeFigure.class, "ActivityFinalNodeFigure" },
        { AMControlFlowFigure.class, "ControlFlowFigure" },
        
        { TextFigure.class, "TextFigure" },
        { GroupFigure.class, "GroupFigure" },
        { TextAreaFigure.class, "TextAreaFigure" },
        
        { AMInitialNodeConnector.class, "InitialNodeConnector" },
        { AMActionConnector.class, "ActionConnector" },
        { AMDecisionNodeConnector.class, "DecisionNodeConnector" },
        { AMActivityFinalNodeConnector.class, "ActivityFinalNodeConnector" },
        { StickyRectangleConnector.class, "StickyRectangleConnector" },
        { ChopRectangleConnector.class, "ChopRectangleConnector" },
        { ChopEllipseConnector.class, "ChopEllipseConnector" },
        { ChopDiamondConnector.class, "ChopDiamondConnector" },
        { BezierLabelLocator.class, "BezierLabelLocator" },
        { SlantedLiner.class, "SlantedLiner" },
        { ArrowTip.class, "ArrowTip" }
    };
    
    /** Creates a new instance. */
    public AMFactory() {
        for (Object[] o : classTagArray) {
            addStorableClass((String) o[1], (Class) o[0]);
        }
    }
}
